clear all
%that is ellipse center (2000,2000) width (40,120)  =(50 nm x150 nm)
k=0.8;   %points per nm
SaveToFile=true; myPath='E:\AMATLAB\reticle\';MyFile='';
rawPlotting=false;

    InLineWidth=30;  %20;
    InLineGapWidth=35;%  25;
disp('started')
%%line   square
if 1==0
    %MyFile='SQ64umx3000';
    XWidth=2E3  ; % nm   x width
    YWidth=16E3; %nm  y width 
    MyObject=[XWidth*k/2 YWidth*k/2;-XWidth*k/2 YWidth*k/2;-XWidth*k/2 -YWidth*k/2;XWidth*k/2 -YWidth*k/2];
    [MyLine, MyAreaOld]=InLineObject(MyObject,InLineWidth);
    [MyLineOld, MyArea]=InLineObject(MyAreaOld,InLineGapWidth);
    AllObjects(1).MyObj=MyArea;
    AllObjects(1).MyRank=1;
    AllObjects(2).MyObj=MyLine;
    AllObjects(2).MyRank=2;
    MyCenterPosition(1)=0;MyCenterPosition(2)=0;
    StandartProcessing
    return
end

%%%% line square old
if 1==0

    MyWidth=2000; % nm   x width
    MyLength=3000; %nm  y width

    %
    MyWidthTop=MyWidth;%
     MyWidthBut=MyWidth;%
     MyLengthLeft=MyLength;
     MyLengthRight=MyLength;
    % adjust
    %
    DoDecompose='non';
    DecomExpWidth=3.75*3;  % nm A3 res 3.75
    DecomposRatio=6;  % how much average exp reduce A3 neg 4.45  pos 2.15
    DecomposNonWidth=DecomExpWidth*(DecomposRatio-1) ; % just monitor
    center=MyLength-2*(InLineWidth+InLineGapWidth);
    myName='SQ2000x3000'   ;
    
      %myName='ChipProt';
    
   XWidth=MyWidth*k; %nm
   YWidth=MyLength*k;%nm

   MyObject=[XWidth/2 YWidth/2;-XWidth/2 YWidth/2;-XWidth/2 -YWidth/2;XWidth/2 -YWidth/2];
   MySizes=findObjectSizes(MyObject);
   
   shift0(2)=0;shift0(1)=0;
   
   if  MyWidth>5000
       shift0(1)=-MySizes(2);
   else
       shift0(1)=(2000-(MySizes(2)+MySizes(1))/2);
   end
      if MyLength>5000
       shift0(2)=-MySizes(4);
   else
       shift0(2)=(2000-(MySizes(4)+MySizes(3))/2);
   end
   MyObject(:,1)=MyObject(:,1)+shift0(1);MyObject(:,2)=MyObject(:,2)+shift0(2);
   
      % in line
   [MyLine, MyAreaOld]=InLineObject(MyObject,InLineWidth);
   MyLine=round(MyLine);MyAreaOld=round(MyAreaOld);
   
   [MyLineOld, MyArea]=InLineObject(MyAreaOld,InLineGapWidth);
   MyArea=round(MyArea);
   MyDecArea=Decompos(MyArea, DecomExpWidth,DecomposRatio,k);
   
   %figure(1); clf;hold on;plotJ01(MyObject); plotJ01(MyArea); hold off;
  %figure(1); plot(MyObject(:,1),MyObject(:,2),MyArea(:,1),MyArea(:,2),MyLine(:,1),MyLine(:,2) )
%figure(1); plot(MyLine(:,1),MyLine(:,2), )
figure(1); clf;hold on;plotJ01(MyLine); plotJ01(MyArea); 
if  DoDecompose=='yes'
for j=1:length(MyDecArea)
    plotJ01(MyDecArea{j}); 
end
end
hold off;

 %figure(1); clf;hold on;plotJ01(MyLine); plotJ01(MyObject); hold off; 
 
MySizes=findObjectSizes(MyObject);

myFileName=['VZ_' myName '.j01'];
fid = fopen(myFileName,'w');
PrintSizesToFile;

fprintf(fid,['* it is square. width ' num2str(MyWidth) ' nm length  ' num2str(MyLength) ' nm \n']);
fprintf(fid,['* inline width ' num2str(InLineWidth) ' nm  inline gap ' num2str(InLineGapWidth) ' nm \n']);
if  DoDecompose=='yes'
    fprintf(fid,['* decompos ratio' num2str(DecomposRatio) '  exp width ' num2str(DecomExpWidth) '  non width ' num2str(DecomposNonWidth) ' nm \n']);
end

fprintf(fid,['ID/VZ_' myName '\n']);
if  DoDecompose=='yes'
for j=1:length(MyDecArea)
    a=MyDecArea{j}; MyLayer=1;PrintToJ01;
end
else
a=MyArea;MyLayer=1;PrintToJ01;
end
a=MyLine;MyLayer=2;PrintToJ01;
fprintf(fid,'EF');
fclose(fid);return
   
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%making ellips
if 1==0
    disp ('making ellips')
    el_size=25; % *100 nm

    el_ratio=1;  % usualy 1.4 for XELLIPS  sometime 2.5
    DoInLine='yes'; %  'yes' 'non'
    DoCenter='yes';
     DoDecompose='non';
    InLineWidth=5; %nm
    GapWidth=0;  % nm
    myName='CircleF'; %'CIRCLE'; %'YELLIPS';XELLIPS 
       myName=[myName num2str(el_size)];
myFileName=['VZ_' myName  '.j01'];
    MyAreaRank=1;MyLineRank=2;
    DecomExpWidth=10; %nm width of explosure
    DecomposRatio=3;  %  % how much average exp reduce A3 neg 4.45  pos 2.15
    DecomposNonWidth=DecomExpWidth*(DecomposRatio-1)  % just monitor
    
        %%%% generate ellipse 
    fi=2:2:360;
    for j=1:length(fi)
    MyMag(j,1)=el_size*0.5*cos(fi(j)*pi/180)*el_ratio;
    MyMag(j,2)=el_size*0.5*sin(fi(j)*pi/180)/el_ratio;
    dydx=MyMag(j,1)/MyMag(j,2)/el_ratio^2;
    Norm=sqrt(1+dydx^2);
    EllipNorm(j,1)=dydx/Norm;EllipNorm(j,2)=1/Norm;
       if fi(j)>180
      EllipNorm(j,2)=-EllipNorm(j,2);
      EllipNorm(j,1)=-EllipNorm(j,1);
       end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 

%%% generate inline
MyInLine(:,1)=MyMag(:,1)-InLineWidth*EllipNorm(:,1); 
MyInLine(:,2)=MyMag(:,2)-InLineWidth*EllipNorm(:,2);
%%%%% generate inner circle
InnerCir(:,1)=MyInLine(:,1)-GapWidth*EllipNorm(:,1); 
InnerCir(:,2)=MyInLine(:,2)-GapWidth*EllipNorm(:,2) ;
%%%

AllInLine(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];AllInLine(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];

MySizes=findObjectSizes(MyMag);
   if  MySizes(1)-MySizes(2)>5000
       shift0(1)=-MySizes(2);
   else
       shift0(1)=(2500-(MySizes(2)+MySizes(1))/2);
   end
      
   if MySizes(3)-MySizes(4)>5000
       shift0(2)=-MySizes(4);
   else
       shift0(2)=(2500-(MySizes(4)+MySizes(3))/2);
   end
   
     
   if  DoDecompose=='yes'
       
       DecoInnerCir=YDecomposCircle(InnerCir, DecomExpWidth,DecomposRatio,1);
      tmp=ToJ01(DecoInnerCir,shift0); DecoInnerCir=tmp;clear tmp; 
       
   %DecoInnerCir=DecomposCircle(InnerCir,EllipNorm, DecomExpWidth,DecomposRatio,k);
   end
   tmp=ToJ01(MyMag,shift0); MyMag=tmp;;clear tmp; 
   tmp=ToJ01(AllInLine,shift0); AllInLine=tmp;clear tmp; 
   tmp=ToJ01(InnerCir,shift0); InnerCir=tmp;clear tmp; 



% put in possition
MySizes=findObjectSizes(MyMag);


   

    

fid = fopen(myFileName,'w');

   % in line
   if DoInLine=='yes'
% reduce resolution
       %AllInLine=round(AllInLine/6)*6;
figure(1); clf;hold on;plotJ01(AllInLine); plotJ01(InnerCir); hold off;


MySizes=findObjectSizes([AllInLine; InnerCir]);

PrintSizesToFile;

fprintf(fid,['* it is ellips. width ' num2str(el_size) ' nm ratio  ' num2str(el_ratio) ' nm  area' num2str(pi*(el_size/2)^2*1E-6) 'um2 \n']);
fprintf(fid,['* in line width ' num2str(InLineWidth) ' in line gap ' num2str(GapWidth) ' \n']);
fprintf(fid,['* area  rank ' num2str(MyAreaRank) ' line rank  ' num2str(MyLineRank) '  \n']);
if  DoDecompose=='yes'
    fprintf(fid,['* decompos ratio' num2str(DecomposRatio) '  exp width ' num2str(DecomExpWidth) '  non width ' num2str(DecomposNonWidth) ' nm \n']);
end
fprintf(fid,['ID/VZ_' myName '\n']);

if DoCenter=='yes'
      if  DoDecompose=='yes'
    figure(1); clf;hold on;plotJ01(AllInLine); 
    for j=1:length(DecoInnerCir);
    plotJ01(DecoInnerCir{j}); 
    a=DecoInnerCir{j};MyLayer=MyAreaRank;PrintToJ01; 
    end 
hold off;
a=AllInLine;MyLayer=MyLineRank;PrintToJ01; 
      else
          figure(1); clf;hold on;plotJ01(AllInLine); plotJ01(InnerCir); hold off;
          a=InnerCir;MyLayer=MyAreaRank;PrintToJ01; 
          a=AllInLine;MyLayer=MyLineRank;PrintToJ01;
      end

else
        figure(1); clf;hold on;plotJ01(AllInLine); hold off;

a=AllInLine;MyLayer=MyLineRank;PrintToJ01; 
end 
else % no inline
    MyMag=round(MyMag);
     MyTmp=RemoveRepeated(MyMag);clear MyMag; MyMag=MyTmp;
    figure(1); clf;plotJ01(MyMag); 
    MySizes=findObjectSizes(MyMag);

PrintSizesToFile;

fprintf(fid,['* it is ellips. width ' num2str(el_size) ' nm ratio  ' num2str(el_ratio) ' nm  area' num2str(pi*(el_size/2)^2*1E-6) 'um2 \n']);

fprintf(fid,['ID/VZ_' myName '\n']);

a=MyMag;MyLayer=1;PrintToJ01; 

end

fprintf(fid,'EF');fclose(fid);return
return
end

%%%%%%%%%%make cross
if 1==1
CrossWidth=4*1E3; %nm
CrossLength=200*1E3; %nm
InLineWidth=20;
    InLineGapWidth=35;
    %
    DoDecompose='non';
    DecomExpWidth=3.75*2 ; % nm A3 res 3.75
    DecomposRatio=6;  % how much average exp reduce A3 neg 4.45  pos 2.15
        DecomposNonWidth=DecomExpWidth*(DecomposRatio-1);  % just monitor
myName='EBReticle';
L=CrossLength/2; dL=CrossWidth/2;
MyObject=[-L -dL; -dL -dL; -dL -L; dL -L; dL -dL; L -dL; L dL; dL dL; dL L; -dL L; -dL dL; -L dL];
%MyObject(:,1)=-MyObject(:,1);b
 

MySizes=findObjectSizes(MyObject);
shift0=[-MySizes(2) -MySizes(4)];
%MyObject(:,1)=MyObject(:,1)+shift0(1);MyObject(:,2)=MyObject(:,2)+shift0(2);
MySizes=findObjectSizes(MyObject*k);
   [MyLine1, MyAreaTmp]=InLineObject(MyObject,InLineWidth);
   %MyLine=round(MyLine);MyArea=round(MyArea);
[tmp1, MyAreaR]=InLineObject(MyAreaTmp,InLineGapWidth);
MyLine=ToJ01(MyLine1,shift0);

if DoDecompose=='yes';
MyArea1=MyAreaR(2:5,:);MyArea2=MyAreaR(8:11,:);MyArea3=[MyAreaR(1,:);MyAreaR(6:7,:);MyAreaR(12,:);];
MyTmp=Decompos(MyArea1, DecomExpWidth,DecomposRatio,1);MyDecArea1=ToJ01(MyTmp,shift0);clear MyTmp;
MyTmp=Decompos(MyArea2, DecomExpWidth,DecomposRatio,1);MyDecArea2=ToJ01(MyTmp,shift0);clear MyTmp;
MyTmp=Decompos(MyArea3, DecomExpWidth,DecomposRatio,1);MyDecArea3=ToJ01(MyTmp,shift0);clear MyTmp;

   figure(1); clf;hold on; plotJ01(MyDecArea1);plotJ01(MyDecArea2);plotJ01(MyDecArea3);plotJ01(MyLine);hold off;
else
    MyArea=ToJ01(MyAreaR,shift0); 
     figure(1); clf;hold on; plotJ01(MyArea);plotJ01(MyLine);hold off;
 end
   
myFileName=['VZ_' myName '.j01'];
fid = fopen(myFileName,'w');
PrintSizesToFile;

fprintf(fid,['* it is cross. line width ' num2str(CrossWidth) 'nm length of each line ' num2str(CrossLength/2) 'nm \n']);
fprintf(fid,['*  this is a cross \n']);
fprintf(fid,['* inline width ' num2str(InLineWidth) ' nm  inline gap ' num2str(InLineGapWidth) ' nm \n']);
if  DoDecompose=='yes'
    fprintf(fid,['* decompos ratio' num2str(DecomposRatio) '  exp width ' num2str(DecomExpWidth) '  non width ' num2str(DecomposNonWidth) ' nm \n']);
end

fprintf(fid,['ID/VZ_' myName '\n']);
fprintf(fid,'* that is area \n');
if DoDecompose=='yes';
    a=MyDecArea1;MyLayer=1;PrintToJ01; 
    a=MyDecArea2;MyLayer=1;PrintToJ01; 
    a=MyDecArea3;MyLayer=1;PrintToJ01; 
else
a=MyArea;MyLayer=1;PrintToJ01; 
end
fprintf(fid,'* that is line \n');
a=MyLine;MyLayer=2;PrintToJ01; 
fprintf(fid,'EF');fclose(fid);return
end 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%join 2 ellipses
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if 1==0
    %diference of elipces axis is 2
    DistanceBetween=900;  % nm
    Ellipse1Diameter=800;  % nm
    Ellipse2Diameter=Ellipse1Diameter;  % nm
    Ellipse1Ratio=1.4;  % 1.4* diameter along x direction
    Ellipse2Ratio=1/Ellipse1Ratio;
    MyName='4D800'

   ShortestDistance=DistanceBetween-(Ellipse2Diameter/Ellipse2Ratio/2+Ellipse1Diameter/Ellipse1Ratio/2)
    
    MyNameS=['ID/VZ_' MyName '\n'];
    myFileName=['VZ_' MyName '.j01'];
    fid = fopen(myFileName,'w');
        %%%%%%%generate circle with diameter 1
    fi=0:2:358;
    for j=1:length(fi)
    MyObject(j,1)=0.5*cos(fi(j)*pi/180);
    MyObject(j,2)=0.5*sin(fi(j)*pi/180);  % diameter 1
    end
    %%%%%%%%%%%%generate two ellipses
    
    MyObject1(:,1)=Ellipse1Diameter*MyObject(:,1)*Ellipse1Ratio;
    MyObject1(:,2)=Ellipse1Diameter*MyObject(:,2)/Ellipse1Ratio;
    MyObject2(:,1)=Ellipse2Diameter*MyObject(:,1)*Ellipse2Ratio;
    MyObject2(:,2)=Ellipse2Diameter*MyObject(:,2)/Ellipse2Ratio;
    
    %MyObject2=MyObject;
    MyObject2(:,2)=MyObject2(:,2)+DistanceBetween;
    
    MyObject1=MyObject1*k;MyObject2=MyObject2*k;  % convert to points
    
    
    %center 
    MySizes=findObjectSizes([MyObject1; MyObject2]);

% center should move to 20000
if MySizes(1)-MySizes(2)<4000 % center should move to 20000
    OffsetX=2000-MySizes(2)-(MySizes(1)-MySizes(2))/2 ; %(MySizes(1)-MySizes(2)) is length
else
    OffsetX=-MySizes(2);
end
if MySizes(3)-MySizes(4)<4000
    OffsetY=2000-MySizes(4)-(MySizes(3)-MySizes(4))/2 ;
else
    OffsetY=-MySizes(4);
end
   
    MyObject1(:,1)=MyObject1(:,1)+OffsetX;MyObject1(:,2)=MyObject1(:,2)+OffsetY;
    MyObject2(:,1)=MyObject2(:,1)+OffsetX;MyObject2(:,2)=MyObject2(:,2)+OffsetY;
    MyObject1=round(MyObject1);  MyObject2=round(MyObject2);
    figure(1); clf;hold on;plotJ01(MyObject1); plotJ01(MyObject2);hold off;
    Both=[MyObject1; MyObject2];

  MySizes=findObjectSizes(Both);PrintSizesToFile;
  fprintf(fid,'*two ellipses \n');
         fprintf(fid,['*ellips1 diameter' num2str(Ellipse1Diameter) ' nm ratio ' num2str(Ellipse1Ratio) ' \n' ]);
         fprintf(fid,['*ellips2 diameter' num2str(Ellipse2Diameter) ' nm ratio ' num2str(Ellipse2Ratio) ' \n' ]);
         fprintf(fid,['*distance between centers ' num2str(DistanceBetween) ' nm shortest distance ' num2str(ShortestDistance) ' nm \n' ]);

    fprintf(fid,MyNameS);

    a=MyObject1;PrintToJ01;a=MyObject2;PrintToJ01;
    fprintf(fid,'EF');
    fclose(fid);return


end

%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%generate area for SEM
%%%%%%%%%%%print for the sem
fprintf(fid,'* in x object is shifted to center. xmax=4000  should be used\n');  
fprintf(fid,'ID/VZ_SEM_C100\n');
MySizes=findObjectSizes(MyObject);

ObjectWidthY=MySizes(3)-MySizes(4); 
ObjectWidthX=MySizes(1)-MySizes(2);  

YShiftNumber=6;
shiftY=ObjectWidthY*2.5;
shiftX=ObjectWidthX*3.7; %that is shift for one step

DeltaInitialY=shiftY/YShiftNumber*1.5;  %that is small shift for next element

MaxX=2000*k; %nm
MaxY=79000*k; %nm
%object should be in 5um line
shift0=[(5000*k-MaxX)/2 ObjectWidthY/2];

figure(1); clf;
hold on

for tmpShiftY=0:shiftY:MaxY
    
    
    InitialY=0;j3=1;
    for tmpShiftX=0:shiftX:MaxX

        a(:,1)=MyObject(:,1)+tmpShiftX+shift0(1);
        a(:,2)=MyObject(:,2)+tmpShiftY+shift0(2)+InitialY;
        PrintToJ01;
        plotJ01(a)         
        InitialY=InitialY+DeltaInitialY; j3=j3+1;
        if j3==YShiftNumber
            MaxInitialY=InitialY-DeltaInitialY;   % only for information
            j3=1;InitialY=0;
        end
        lastSiftX=tmpShiftX;    % only for information
    end
    %pause
    
  lastSiftY=tmpShiftY;  % only for information
end

MinXPoints=shift0(1)-ObjectWidthX/2;
MaxXPoints=shift0(1)+lastSiftX+ObjectWidthX/2;
CenterX=(MaxXPoints+MinXPoints)/2;
WidthX=(MaxXPoints-MinXPoints);

MinYPoints=shift0(2)-ObjectWidthY/2;
MaxYPoints=shift0(2)+ObjectWidthY/2+MaxInitialY+lastSiftY;
CenterY=(MaxYPoints+MinYPoints)/2;
WidthY=(MaxYPoints-MinYPoints);
hold off
fprintf(fid,'EF\n');

fprintf(fid,'* Points Xmin=%g  Xmax=%g  Xcenter=%g Xwidth =%g \n',[MinXPoints MaxXPoints CenterX WidthX]);
fprintf(fid,'* Points Ymin=%g  Ymax=%g  Ycenter=%g Ywidth =%g \n',[MinYPoints MaxYPoints CenterY WidthY]);
fprintf(fid,'* nm Xmin=%g  Xmax=%g  Xcenter=%g Xwidth =%g \n',[MinXPoints/0.8 MaxXPoints/0.8 CenterX/0.8 WidthX/0.8]);
fprintf(fid,'* nm Ymin=%g  Ymax=%g  Ycenter=%g Ywidth =%g \n',[MinYPoints/0.8 MaxYPoints/0.8 CenterY/0.8 WidthY/0.8]);

fclose(fid);


